local JCMDConv = {
	TapNoteScore_ProW1 = "W1Command",
	TapNoteScore_ProW2 = "W1Command",
	TapNoteScore_ProW3 = "W1Command",
	TapNoteScore_ProW4 = "W1Command",
	TapNoteScore_ProW5 = "W1Command",
	TapNoteScore_W1 = "W1Command",
	TapNoteScore_W2 = "W1Command",
	TapNoteScore_W3 = "W1Command",
	TapNoteScore_W4 = "W1Command",
	TapNoteScore_W5 = "W1Command",
	TapNoteScore_Miss = "W1Command"
}

local sPlayer = Var "Player"

-- Note that this does not really represent a CMD in lua.
-- This is grabbing the metric from the current theme.
local function GetJCMD(Type,JCMD)
	if Type == 1 then Type = "Judgment" else Type = "Protiming" end
	return THEME:GetMetric( Type, Type..JCMDConv[JCMD] )
end

-- 
local function GetTexture()
	return THEME:GetPathG("","Player judgment/" .. LoadModule("Gameplay.AutoJudgeGraphics.lua")())
end
--local bProtiming = LoadModule("Config.Load.lua")("ProTiming",PROFILEMAN:GetProfileDir(string.sub(sPlayer,-1)-1).."/OutFoxPrefs.ini")
local bProtiming = false

local Name,Length = LoadModule("Options.SmartTapNoteScore.lua")()
table.sort(Name)
Name[#Name+1] = "Miss"

local HNSConv = {
	HoldNoteScore_Held = "TapNoteScore_" .. Name[1],
	HoldNoteScore_LetGo = "TapNoteScore_Miss",
}

local curStyle = GAMESTATE:GetCurrentStyle()

local t = Def.ActorFrame {}

-- PER-COLUMN JUDGMENTS!!!
for i=1, curStyle:ColumnsPerPlayer() do
	t[#t+1] = Def.ActorFrame {
		Name = "Judg_" .. tostring(i-1),
		
		Def.Sprite{
			Name="Judgment",
			Texture=GetTexture(),
			InitCommand=function(self)
				local evenCols = curStyle:ColumnsPerPlayer() % 2 == 0
				local adjI = (i - 0.5) - (curStyle:ColumnsPerPlayer()/2)
				local adjYI = evenCols and (i % 2 == 0 and 0 or 1) or adjI
				self:pause():visible(false)
				self:x(60 * adjI ):y(30 + (-30 * math.abs(adjYI)))
			end,
			OnCommand=THEME:GetMetric("Judgment","JudgmentOnCommand"),
			ResetCommand=function(self) self:finishtweening():stopeffect():visible(false) end
		},
		-- LoadFont("Common Normal") .. {
			-- Name="Protiming",
			-- Text="",
			-- InitCommand=function(self) self:visible(false) end,
			-- OnCommand=THEME:GetMetric("Protiming","ProtimingOnCommand"),
			-- ResetCommand=function(self) self:finishtweening():stopeffect():visible(false) end
		-- },
		JudgmentMessageCommand=function(self, params)
			--SM(params)
			local Judg = self:GetChild("Judgment")
			--local Prot = self:GetChild("Protiming")
			
			-- all the abort cases at once
			if params.Player ~= sPlayer then return end
			local theTNS
			
			if params.Notes then 
				if not params.Notes[i] then return end
				theTNS = params.TapNoteScore
			else
				if params.HoldNoteScore and MergeHNSWithTNS() then
					if params.FirstTrack ~= i-1 then return end
					if not HNSConv[params.HoldNoteScore] then return end
					theTNS = HNSConv[params.HoldNoteScore]
				else
					return
				end
			end

			--local jPath = string.match(Judg:GetTexture():GetPath(), ".*/(.*)")
			local iFrame

			for i = 1,#Name do
				if theTNS == "TapNoteScore_"..Name[i] then iFrame = i-1 end
			end

			if not iFrame then return end
			-- if string.find(jPath, "%[double%]")then
				-- iFrame = iFrame * 2
				-- if not params.Early then
					-- iFrame = iFrame + 1
				-- end
			-- end

			self:playcommand("Reset")

			Judg:visible( true )
			Judg:setstate( iFrame )
			GetJCMD(1,theTNS)(Judg)

			--Prot:visible( bProtiming )
			--Prot:settext( math.floor(math.abs(params.TapNoteOffset * 1000)) .. " ms" );
			--GetJCMD(1,params.TapNoteScore)(Prot)
		end
	}
end

return t
